#include <algorithm>
#include <cmath>
#include <iostream>
#include <map>
#include <math.h>
#include <utility>
#include <vector>
using namespace std;

// This solution will not use union find, and instead
// check how many island each island can reach one at a time
// using dfs

class Graph
{
public:
    bool *visited;
    vector<int> *adj;

    void addEdge(int v, int w);

    vector<int> DFS(int v, vector<int> component);

    Graph(int n) {
        visited = new bool[n]();
        adj = new vector<int>[n]();
    }
};

void Graph::addEdge(int v, int w)
{
    adj[v].push_back(w);
}

vector<int> Graph::DFS(int v, vector<int> component) {
    if (visited[v]) {
            return component;
        }
    visited[v] = true;
    component.push_back(v);

    for (int i=0; i < adj[v].size(); ++i)
        if (!visited[adj[v][i]])
            return DFS(adj[v][i], component);

    return component;
}

int main() {
    int n, d;
    cin >> n >> d;

    pair<int, int> *islands;

    islands = new pair<int, int>[n]();

    // read input and create an array of the islands
    for (int i = 0; i < n; i++) {
        int x, y;
        cin >> x >> y;
        islands[i] = make_pair(x, y);
    }

    Graph g = Graph(n);

    // Creates edges between islands
    for (int i=0; i < n-1; i++) {
        for (int j= i + 1; j < n; j++) {
            pair<int, int> island1 = islands[i];
            pair<int, int> island2 = islands[j];
            if (d >= sqrt(
                pow(abs(island2.first - island1.first), 2.0)
                + pow(abs(island2.second - island1.second), 2.0))) {
                    g.addEdge(i, j);
                    g.addEdge(j, i);
                    cout << "Added edge between: " << i << " " << j << endl;
            }
        }
    }

    vector<int> largest_component(0);

    // DFS starting at each island and keeping track of largest component found
    for (int i=0; i < n; i++) {
        vector<int> component = g.DFS(i, vector<int>(0));
        if (component.size() > largest_component.size()) {
            largest_component = component;
            for (int j=0; j < largest_component.size(); j++) {
                cout << largest_component[j] << " ";
            }
            cout << endl;
        }
    }

    for (int i=0; i < largest_component.size(); i++) {
        cout << largest_component[i] + 1 << ' ';
    }
    cout << endl;

}