import java.util.ArrayList;
import java.util.Comparator;
import java.util.Scanner;

public class simen {

    static boolean [] visited;
    static ArrayList<ArrayList<Integer>> graph;

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        int N = sc.nextInt();
        double fuel = sc.nextDouble();

        int [] xs = new int[N];
        int [] ys = new int[N];

        for (int i = 0; i < N; i++) {
            xs[i] = sc.nextInt();
            ys[i] = sc.nextInt();
        }

        graph = new ArrayList<>();
        for (int i = 0; i < N; i++) {
            ArrayList<Integer> adjacent = new ArrayList<>();
            for (int j = 0; j < N; j++) {
                if (i != j && distance(xs[i], ys[i], xs[j], ys[j]) <= fuel) {
                    adjacent.add(j);
                }
            }

            graph.add(adjacent);
        }

        ArrayList<ArrayList<Integer>> groups = new ArrayList<>();
        visited = new boolean[N];

        for (int i = 0; i < N; i++) {
            if (!visited[i]) {
                groups.add(dfs(i, new ArrayList<>()));
            }
        }

        groups.sort(Comparator.comparingInt(g -> -g.size()));
        groups.forEach(group -> group.forEach(g -> System.out.print(g+1 + " ")));

        sc.close();
    }

    static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2) + Math.pow(y1 - y2, 2));
    }

    static ArrayList<Integer> dfs(int v, ArrayList<Integer> group) {
        group.add(v);
        visited[v] = true;

        for (Integer u : graph.get(v)) {
            if (!visited[u]) {
                dfs(u, group);
            }
        }

        return group;
    }
}