
import java.io.*;
import java.util.*;

public class brigt {
    public static void main(String[] args) {
        Kattio in = new Kattio(System.in);

        int numberOfIslands = in.getInt();
        int ferryDistance = in.getInt();
        int ferryDistancePow = ferryDistance*ferryDistance;


        // First we create maps to go from points to index
        // and add to index to adjList
        HashMap<Integer, List<Integer>> adjList = new HashMap<>();
        HashMap<Point, Integer> pointToIdx = new HashMap<>();
        HashMap<Integer, Point> idxToPoint = new HashMap<>();
        for (int i = 0; i < numberOfIslands; i++) {
            int x = in.getInt();
            int y = in.getInt();
            Point point = new Point(x,y);
            pointToIdx.put(point, i);
            idxToPoint.put(i, point);
            adjList.put(i, new ArrayList<>());
        }

        // Create the graph
        for (int i = 0; i < numberOfIslands; i++) {
            for (int j = i+1; j < numberOfIslands; j++) {
                if(idxToPoint.get(i).distanceToPow(idxToPoint.get(j))<=ferryDistancePow){
                    adjList.get(i).add(j);
                    adjList.get(j).add(i);
                }
            }
        }

        // We now want to create
        boolean[] visited = new boolean[numberOfIslands];
        List<List<Integer>> allComponents = new ArrayList<>();

        for (int i = 0; i < numberOfIslands; i++) {
            if(visited[i]){
                continue;
            }
            visited[i] = true;
            List<Integer> currentComponent = new ArrayList<>();
            currentComponent.add(i);

            PriorityQueue<Integer> queue = new PriorityQueue<>();
            for (Integer neighbour: adjList.get(i)) {
                queue.add(neighbour);
                currentComponent.add(neighbour);
                visited[neighbour]=true;
            }

            while(!queue.isEmpty()){
                int curr = queue.poll();
                for(Integer neighbour: adjList.get(curr)){
                    if(!visited[neighbour]){
                        queue.add(neighbour);
                        currentComponent.add(neighbour);
                        visited[neighbour]=true;
                    }
                }
            }
            allComponents.add(currentComponent);
        }

        allComponents.sort(new Comparator<List<Integer>>() {
            @Override
            public int compare(List<Integer> o1, List<Integer> o2) {
                return o2.size()-o1.size();
            }
        });
        for (int i = 0; i < allComponents.size(); i++) {
            List<Integer> current = allComponents.get(i);

            System.out.print(current.get(0)+1);
            for (int j = 1; j < current.size(); j++) {
                System.out.print(" " + (current.get(j)+1));
            }
            if(i== allComponents.size()-1){
                break;
            }
            System.out.print(" ");

        }
        System.out.flush();




    }
}

class Kattio extends PrintWriter {
    public Kattio(InputStream i) {
        super(new BufferedOutputStream(System.out));
        r = new BufferedReader(new InputStreamReader(i));
    }
    public Kattio(InputStream i, OutputStream o) {
        super(new BufferedOutputStream(o));
        r = new BufferedReader(new InputStreamReader(i));
    }

    public boolean hasMoreTokens() {
        return peekToken() != null;
    }

    public int getInt() {
        return Integer.parseInt(nextToken());
    }

    public double getDouble() {
        return Double.parseDouble(nextToken());
    }

    public long getLong() {
        return Long.parseLong(nextToken());
    }

    public String getWord() {
        return nextToken();
    }



    private BufferedReader r;
    private String line;
    private StringTokenizer st;
    private String token;

    private String peekToken() {
        if (token == null)
            try {
                while (st == null || !st.hasMoreTokens()) {
                    line = r.readLine();
                    if (line == null) return null;
                    st = new StringTokenizer(line);
                }
                token = st.nextToken();
            } catch (IOException e) { }
        return token;
    }

    private String nextToken() {
        String ans = peekToken();
        token = null;
        return ans;
    }
}

class Point{
    public int x;
    public int y;

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int distanceToPow(Point point){
        return (point.x-x)*(point.x-x)+(point.y-y)*(point.y-y);
    }
}
