#!/usr/bin/env bash

### Master generator (run this from the ./generators folder to generate)
MAXN=2000

## Solver
SOLVER=../submissions/accepted/torstein.py

## Destination for generated files
# CAREFUL! EVERYTHING IN THIS DIRECTORY WILL BE ERASED
DESTBASE="../data/secret/gen"
rm -r -f $DESTBASE
mkdir $DESTBASE
DEST="${DESTBASE}"
echo $DEST

# Calling the generation script
COUNT=0
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    ./generate.py -s $COUNT -n $1 -d $2 -o $3 -r $4 > $DEST/${padCount}_n$1_d$2_$3_$4.in
}

for n in 25 $MAXN
do
    generate $n 3 ran 0
    generate $n 3 grid 0
    generate $n 5 disconnect-snake 0
    generate $n 3 snake 0
    generate $n 3 disconnect-snake 0
    generate $n 12 ran-rev 0
    generate $((n-5)) 10 grid 5
    generate $n `echo "3*sqrt($n)/2" | bc` clique 0
done

# Generate solutions
if [[ ! -z $SOLVER ]]
then
    for f in $DEST/*.in
    do
        echo "solving $f"
        $SOLVER < $f > ${f%???}.ans
    done
fi
