#!/usr/bin/env python3
TGLENGTH = 100
trip = [tuple(map(float, input().split())) for _ in range(int(input()))]
n = len(trip)

# times = [x[2] for x in trip] # If time is given relative to last time, not in absoulte.
times = []   # If time is given as absolute, not relative to last time

lengths = []
px, py, pt = 0.0, 0.0, 0.0
for x, y, t in trip:
    times.append(t-pt)  # If time is given as absolute, not relative to last time
    lengths.append(((px-x)**2 + (py-y)**2)**0.5) # if time is given in relative, not in absoult
    px, py, pt = x, y, t

# Observation: There exists a quickest 100m that either start or end at
# a measured point.

def one_direction_search(lengths, times):
    cumulative_dist = [0.0]
    for leg in lengths:
        cumulative_dist.append(cumulative_dist[-1] + leg)

    cumulative_time = [0.0]
    for time in times:
        cumulative_time.append(cumulative_time[-1] + time)

    ## How fast was quickest 100 meter run that STARTS in a provided
    ## location.
    n = len(cumulative_time)
    beg = 0
    end = 0
    quickest = float('inf')

    while end < n:
        # If distance between beg and end is below 100, increment end
        if cumulative_dist[end] - cumulative_dist[beg] < TGLENGTH:
            end += 1
        else:
            # Check the 100m starting at 'beg'. Note that 'end'-1 is
            # closer than 100m away, otherwise end would not have been
            # incremented it. Need to figure which fraction of the last 
            # leg to use.

            dist_to_end = cumulative_dist[end] - cumulative_dist[beg]
            assert(dist_to_end >= TGLENGTH)
            remainder_dist = dist_to_end - TGLENGTH

            time_to_end = cumulative_time[end] - cumulative_time[beg]
            speed_last_leg = (cumulative_dist[end] - cumulative_dist[end-1])/(cumulative_time[end] - cumulative_time[end-1])

            time_to_compare = time_to_end - remainder_dist/speed_last_leg
            assert(time_to_compare > 0)
            quickest = min(quickest, time_to_compare)

            # Next step: check next start point
            beg += 1

    return quickest

print(min(one_direction_search(lengths, times), one_direction_search(reversed(lengths), reversed(times))))
