#!/usr/bin/env python3
import math
# note, we might have to check both ways, but at current time only check forwards.
def get_fastet_100_meter(location_list, time_list):
    target_distance = 100
    from_idx = 0
    to_idx = 1
    best_time = float("inf")
    done = False
    best_start = -1
    best_end = -1
    while from_idx < len(location_list) and not done:
        # We want to find out how far we can run from from_idx before we reach the target_distance
        while location_list[to_idx] - location_list[from_idx] < target_distance:
            to_idx += 1
            if to_idx >= len(location_list):
                done = True
                break
        if done:
            break
        # To find excat time for 100m we need to know how much of the last part we should include.
        # First find how much we ran before last part
        distance_covered_before_last_part = location_list[to_idx-1] - location_list[from_idx]
        time_used_before_last_part = time_list[to_idx-1] - time_list[from_idx]

        # Find time spent in last part
        reminding_distance = target_distance - distance_covered_before_last_part
        last_part_average_pace = (location_list[to_idx]-location_list[to_idx-1])/(time_list[to_idx]-time_list[to_idx-1])  # Find pace of last part
        time_spent_last_part = reminding_distance/last_part_average_pace

        # combined
        total_time_spent = time_used_before_last_part + time_spent_last_part

        if best_time > total_time_spent:
            best_time = total_time_spent
            best_start = from_idx
            best_end = to_idx
        """
        # Checking ending at to_index, starting between from_idx and from_idx +1
        distance_covered_after_first_part = location_list[to_idx]-location_list[from_idx+1]
        time_used_before_after_first_part = time_list[to_idx] - time_list[from_idx+1]

        # Find time spent in last part
        reminding_distance = target_distance - distance_covered_after_first_part #PROBLEM! 
        first_part_average_pace = (location_list[from_idx+1]-location_list[from_idx])/(time_list[from_idx+1]-time_list[from_idx])  # Find pace of last part
        time_spent_first_part = reminding_distance/first_part_average_pace

        # combined
        total_time_spent = time_used_before_after_first_part + time_spent_first_part

        if best_time > total_time_spent:
            best_from = from_idx
            best_to = to_idx
            best_time = total_time_spent

        """

        from_idx += 1
    
    #print(f"Best 100m dash time: {best_time}. From: {best_start} to: {best_end}")
    return best_time

def distance_between_locations(loc1, loc2):
    return math.sqrt(math.pow(loc1[0]-loc2[0],2)+math.pow(loc1[1]-loc2[1],2))

def main():
    global  counter
    nr_of_data_points = int(input())
    locations = []
    time_aggregaded= [0]
    for i in range(nr_of_data_points):
        x,y,t = list(map(float, input().split()))
        locations.append((x,y))
        time_aggregaded.append(t)
    
    distace_aggregaded = [0]
    prev_loc = (0,0)
    for loc in locations:
        distace_aggregaded.append(distance_between_locations(loc, prev_loc)+distace_aggregaded[-1])
        prev_loc = loc
    

    curr_best = get_fastet_100_meter(distace_aggregaded, time_aggregaded)
    reversed_time_list = []
    end_time = time_aggregaded[-1]
    for time in reversed(time_aggregaded):
        reversed_time_list.append(end_time-time)
        #print(reversed_time_list[-1], end=",")
    #print()

    reversed_distance = []
    max_distance = distace_aggregaded[-1]
    for distance in reversed(distace_aggregaded):
        reversed_distance.append(max_distance-distance)
        #print(reversed_distance[-1], end=",")
    #print()

    
    curr_best = min(curr_best, get_fastet_100_meter(reversed_distance, reversed_time_list))
    print(curr_best)

    



if __name__ == "__main__":
    main()