#!/usr/bin/env bash

MAXP=100000
MAXF=1000
MAXA=1000
MAXX=100
MAXY=100
MAXT=20
SEED=1338
END=10

DESTINATION="../data/secret/generated"
rm -rf $DESTINATION
mkdir -p $DESTINATION

for i in $(seq 1 $END)
do
    ./generate.py -i $i -p $MAXP -x $MAXX -y $MAXY -f $MAXF -t $MAXT -s $SEED > $DESTINATION/secret_$i.in
done

END_SMALL=10
for i in $(seq 1 $END_SMALL)
do
      ./generate_small.py -i $i -p $MAXP -x $MAXX -y $MAXY -t $MAXT -s $SEED > $DESTINATION/secret_small_$i.in
done


for f in $DESTINATION/*.in
do
    echo "solving $f"
    ../submissions/accepted/brigt.py < $f > ${f%???}.ans
done
