#!/usr/bin/env python3
import sys, argparse, random, math

def main():
    parser = argparse.ArgumentParser(description="Generator for 100mdash problem.")
    parser.add_argument('-i', metavar='I', type=int, required=True, help='iteration')
    parser.add_argument('-p', metavar='P', type=int, required=True, help='max number of points')
    parser.add_argument('-x', metavar='M', type=int, required=True, help='max x value')
    parser.add_argument('-y', metavar='Y', type=int, required=True, help='max y value')
    parser.add_argument('-t', metavar='T', type=int, required=True, help='max t increase')
    parser.add_argument('-f', metavar='F', type=int, required=True, help='Factor of down scale')
    parser.add_argument('-s', metavar='S', type=int, required=True, help='seed')

    args = parser.parse_args()

    random.seed(args.i+args.p+args.x+args.y+args.t+args.f+args.s)
    maxPoints = args.p#//math.pow(args.i,1.4) # Want some different values.

    itr = random.randint(1, maxPoints)
    time = 0
    total_distance = 0
    prevX = 0
    prevY = 0
    dataToBePrinted = []
    total_counter = itr
    for i in range(itr):
        x = random.randint(-args.x, args.y)
        y = random.randint(-args.y, args.y)
        t = random.randint(1,args.t)+10
        time += t
        dataToBePrinted.append((x,y,time))
        total_distance += math.sqrt(math.pow(x-prevX,2) + math.pow(y-prevY, 2))

    while total_distance < 200:
        x = random.randint(-args.x, args.y)
        y = random.randint(-args.x, args.y)
        t = random.randint(1,args.t)+10
        time += t
        dataToBePrinted.append((x,y,time))
        total_distance += math.sqrt(math.pow(x-prevX,2) + math.pow(y-prevY, 2))
        total_counter += 1

    print(total_counter)
    for (x,y,time) in dataToBePrinted:
        f_x = "{:.6f}".format(x)
        f_y = "{:.6f}".format(y)
        f_time = "{:.6f}".format(time)
        print(f_x, f_y, f_time)




if __name__ == "__main__":
    main()
