#!/usr/bin/env python3
import sys, argparse, random

parser = argparse.ArgumentParser(description="Generator for killingchaos.")    
parser.add_argument('-n', metavar='N', type=int, required=True,
                    help='number of coaches')
parser.add_argument('-o', metavar='O', type=str, default="random",
                    help='options')
parser.add_argument('-s', metavar='S', type=int, default=None,
                    help='seed')
args = parser.parse_args()
random.seed(args.s)

MAXK = 100

n = args.n
options = args.o

train = []
order = []


if "max" in options:
    train = [MAXK] * n
else:
    train = [random.randrange(1, MAXK + 1) for _ in range(n)]
    
    
if "even" in options:
    order = list(range(2, n + 1, 2)) + list(range(1, n + 1, 2))
elif "odd" in options:
    order = list(range(1, n + 1, 2)) + list(range(2, n + 1, 2))
elif "third" in options:
    first = list(range(1, n + 1, 3))
    rest = set(range(1, n + 1))
    for e in first:
        rest.remove(e)
    rest = list(rest)
    random.shuffle(first)
    random.shuffle(rest)
    order = first + rest
elif "inc" in options:
    order = list(range(1, n + 1))
elif "fiswap" in options:
    order = list(range(1, n + 1))
    order[0], order[1] = order[1], order[0]
elif "laswap" in options:
    order = list(range(1, n + 1))
    order[-2], order[-1] = order[-1], order[-2]
elif "filaswap" in options:
    order = list(range(1, n + 1))
    order[0], order[-1] = order[-1], order[0]
else:
    order = list(range(1, n + 1))
    random.shuffle(order)
    
    
if "rev" in options:
    order = reversed(order)


print(n)
print(" ".join(str(x) for x in train))
print(" ".join(str(x) for x in order))
