#!/bin/bash

# Set the problem name to generate correct file names
PROBLEMNAME="bowl"

# Set this if you want to generate answers.
# g++ -O2 submissions/accepted/sol.cpp -o /tmp/a.out
cp ../../submissions/accepted/torstein_simple.py /tmp/sol.py
SOLVER=/tmp/sol.py
MAXN=999999

subfolders=(a_small b_big) # (folderA folderB folderC)
for i in ${subfolders[@]}
do
    rm -r $i
    if [ ! -d $i ]
    then
        mkdir $i
    fi
done

COUNT=0
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    ./gendata.py -s $COUNT -n $1 -o $2 > $DR/${padCount}_n$1_$2.in
}

echo "Generating dataset 1... (manual)"
DR="a_small"

generate 4 OO
generate 4 OW
generate 4 OH
generate 4 WH
generate 5 OO
generate 5 OW
generate 5 OH
generate 5 WH

DR="b_big"

generate $MAXN OO
generate $MAXN OW
generate $MAXN OH
generate $MAXN WH
generate $(($MAXN - 1)) OO
generate $(($MAXN - 1)) OW
generate $(($MAXN - 1)) OH
generate $(($MAXN - 1)) WH

# generate solutions for all files
if [[ ! -z $SOLVER ]]
then
    for i in ${subfolders[@]}
    do
        for f in $i/*.in
        do
            echo "solving $f"
            $SOLVER < $f > ${f%???}.ans
        done
    done
fi
