#!/usr/bin/env python3
import sys, argparse, random
# Generate a single testcase for bowl

parser = argparse.ArgumentParser(description="Generator for howl.")    
parser.add_argument('-n', metavar='N', type=int, required=True,
                    help='length of howl')
parser.add_argument('-o', metavar='O', type=str, default=None,
                    help='options')
parser.add_argument('-s', metavar='S', type=int, default=None,
                    help='seed')
args = parser.parse_args()
random.seed(args.s)

n = args.n
options = args.o

if "OW" in options:
    word = ["A", "H"] + ["O"] * (n - 3) + ["W"]
elif "OH" in options:
    word = ["A", "W"] + ["O"] * (n - 3) + ["H"]
elif "WH" in options:
    word = ["A"] + ["O"] * (n - 3) + ["W", "H"]
else:
    word = ["A", "W", "H"] + ["O"] * (n - 3)

print("".join(word))
