import math
import heapq
import sys

sys.setrecursionlimit(1000000)

class Node:
	def __init__(self, name, gdp, capita):
		self.name = name
		self.gdp_per_capita = gdp / (capita + 0.)
		self.capita = capita
		self.children = []
	def __lt__(self, n2):
		return self.gdp_per_capita > n2.gdp_per_capita
	def __gt__(self, n2):
		return self.gdp_per_capita < n2.gdp_per_capita
	def __str__(self):
		return "[{}: pop:{}, g/c:{}, children:{}]".format(self.name, self.capita, self.gdp_per_capita, map(lambda x: x.name, self.children))

#read input
n = int (raw_input())
gdp = map(int, raw_input().split())
capita = map(int, raw_input().split())
cities = []
for i in range(n):
	cities.append(Node(i, gdp[i], capita[i]))
edges = [ [] for i in range(n)]
for i in range(n-1):
	u, v = map(int, raw_input().split())
	edges[u-1].append(v-1)
	edges[v-1].append(u-1)

#build rooted tree
visited = [False] * n
stack = [0]
while stack:
	u = stack.pop()
	if visited[u]:
		continue
	visited[u] = True
	for v in edges[u]:
		if not visited[v]:
			stack.append(v)
			cities[u].children.append(cities[v])

#merge heaps
def merge(heap1, heap2):
	if len(heap1) < len(heap2):
		temp = heap1
		heap1 = heap2
		heap2 = temp
	for node in heap2:
		heapq.heappush(heap1, node)
	return heap1

#Reduction rules, in DFS order
dfs_stack = [(0, cities[0])]
while dfs_stack:
	op, node = dfs_stack.pop()
	#print node
	if op == 0:
		dfs_stack.append( (1, node) )
		for child in node.children:
			dfs_stack.append( (0, child) )
	if op == 1:
		node.children.sort()
		while node.children and not node < node.children[0]:
			node2 = heapq.heappop(node.children)
			node.gdp_per_capita = (node.gdp_per_capita*node.capita + node2.gdp_per_capita*node2.capita) / (node.capita + node2.capita)
			node.capita += node2.capita
			node.children = merge(node.children, node2.children)

#print answer
print cities[0].gdp_per_capita
