#!/bin/bash

# Set the problem name to generate correct file names
PROBLEMNAME="bowl"

# Set this if you want to generate answers.
# g++ -O2 submissions/accepted/sol.cpp -o /tmp/a.out
cp ../../submissions/accepted/torstein_O1.py /tmp/sol.py
SOLVER=/tmp/sol.py
MAXK=10
MAXW=100
MAXL=100

subfolders=(manual) # (folderA folderB folderC)
for i in ${subfolders[@]}
do
    rm -r $i
    if [ ! -d $i ]
    then
        mkdir $i
    fi
done

COUNT=1
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    ./gendata.py -s $COUNT -k $1 -w $2 -l $3 > $DR/${padCount}_n$1_p$2_$3.in
}

echo "Generating dataset 1... (manual)"
DR="manual"

generate 1 1 100
generate 1 50 75
generate 1 80 80
generate 1 100 1
generate 1 13 87
generate 1 13 40

generate 2 1 100
generate 2 50 50
generate 2 95 95
generate 2 100 1
generate 2 13 87
generate 2 13 40

generate 3 1 100
generate 3 50 50
generate 3 2 1
generate 3 100 1
generate 3 13 87
generate 3 13 40

generate 9 1 100
generate 9 45 45
generate 9 80 30
generate 9 100 1
generate 9 13 87
generate 9 13 40

generate 10 1 100
generate 10 1 1
generate 10 100 100
generate 10 100 1
generate 10 13 87
generate 10 13 40


# generate solutions for all files
if [[ ! -z $SOLVER ]]
then
    for i in ${subfolders[@]}
    do
        for f in $i/*.in
        do
            echo "solving $f"
            $SOLVER < $f > ${f%???}.ans
        done
    done
fi
