#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <algorithm>
#include <ctime>
#include <cmath>
#include <string>
#include <iomanip>
#include <vector>
#include <set>
#include <map>
#include <unordered_set>
#include <unordered_map>
#include <cassert>
#include <queue>
#include <bitset>

using namespace std;

#define clr(a) memset(a, 0, sizeof(a))
#define pb push_back
#define forab(i, a, b) for(int i = int(a); i < int(b); ++i)
#define forba(i, b, a) for(int i = int(b) - 1; i >= int(a); --i)
#define forn(i, n) forab(i, 0, n)

typedef long long ll;
typedef long double ld;

const int INF = 1e9;
const int MAXN = 210;
const int MAXK = 55;

const ld PI = acos((ld)-1.0);
const ld EPS = 1e-9;

ld dp[MAXN][MAXK][2];

void upd(ld& a, ld b) {
    a = min(a, b);
}

int main() {
#ifdef LOCAL
//    freopen("1.in", "r", stdin);
    //freopen("", "w", stdout);
    //freopen("", "w", stderr);
#endif
    cin.sync_with_stdio(false);
    cin.tie(0);
    int n, k;
    cin >> n >> k;
    vector<ld> x(n), y(n);
    for (int i = 0; i < n; ++i) {
        cin >> x[i] >> y[i];
    }
    vector<ld> a(n);
    vector<ld> len(n - 1);
    a[0] = 180;
    for (int i = 0; i < n - 2; ++i) {
        ld px = x[i + 1] - x[i], py = y[i + 1] - y[i];
        ld nx = x[i + 2] - x[i + 1], ny = y[i + 2] - y[i + 1];
        a[i + 1] = 180 - abs(atan2(px * ny - nx * py, px * nx + py * ny)) / PI * 180;
    }

    a[n - 1] = 0;
    for (int i = 0; i < n - 1; ++i) {
        ld px = x[i + 1] - x[i], py = y[i + 1] - y[i];
        len[i] = sqrt(px * px + py * py);
//        cerr << a[i] << ' ' << len[i] << '\n';
    }


    for(int last = 0; last < n - 1; ++last) {
        for (int used = 0; used <= k; ++used) {
            for (int i = 0; i < 2; ++i) {
                dp[last][used][i] = numeric_limits<ld>::infinity();
            }
        }
    }

    dp[0][0][0] = 0;
    dp[0][0][1] = len[0] / 180;
    for(int last = 1; last < n - 1; ++last) {
        if (a[last] < 180 - EPS) {
            break;
        }
        dp[last][0][0] = dp[last - 1][0][1];
        dp[last][0][1] = dp[last][0][0] + len[last] / 180;
    }

    for(int last = 1; last < n - 1; ++last) {
        for (int used = 1; used <= k; ++used) {
            ld minSpeed = 180;
            ld totalDist = 0;
            for (int corner = last; corner > 0; --corner) {
                minSpeed = min(minSpeed, a[corner]);
                totalDist += len[corner];
                upd(dp[last][used][1], dp[corner - 1][used - 1][1] + totalDist / minSpeed);
                upd(dp[last][used][0], dp[corner - 1][used - 1][1] + (totalDist - len[last]) / minSpeed);
                upd(dp[last][used][1], dp[corner - 1][used - 1][0] + (totalDist + len[corner - 1]) / minSpeed);
                upd(dp[last][used][0], dp[corner - 1][used - 1][0] + (totalDist - len[last] + len[corner - 1]) / minSpeed);
            }

            upd(dp[last][used][1], dp[last][used - 1][0] + len[last] / 180);
//            cerr << last << ' ' << used << ' ' << dp[last][used][0] << ' ' << dp[last][used][1] << '\n';
        }
    }

    ld ans = numeric_limits<ld>::infinity();
    for (int used = 0; used <= k; ++used) {
        upd(ans, dp[n - 2][used][1]);
    }

    cout << fixed << setprecision(20) << ans << '\n';
    
    return 0;
}

