#!/bin/bash

# Set the problem name to generate correct file names
PROBLEMNAME="alehouse"

# Set this if you want to generate answers.
# g++ -O2 submissions/accepted/sol.cpp -o /tmp/a.out
cp ../../submissions/accepted/torstein_kn2.py /tmp/sol.py
SOLVER=/tmp/sol.py
MAXN=200
MAXK=50

subfolders=(a_small b_big) # (folderA folderB folderC)
for i in ${subfolders[@]}
do
    rm -r $i
    if [ ! -d $i ]
    then
        mkdir $i
    fi
done

COUNT=0
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    ./gendata.py -s $COUNT -n $1 -k $2 -o $3 > $DR/${padCount}_n$1_k$2_$3.in
}

echo "Generating dataset 1... (manual)"
DR="a_small"

generate 7 10 random
generate 7 9 random
generate 10 10 fewturns5
generate 10 9 fewturns5
generate 10 8 fewturns5
generate 10 1 fewturns1
generate 10 2 fewturns1
generate 10 1 increaseY
generate 10 2 increaseBoth
generate 10 3 random
generate 10 4 fewturns0
generate 10 5 increaseX
generate 10 6 increaseY
generate 10 7 increaseBoth
generate 10 8 random
generate 10 9 increaseBoth

DR="b_big"

generate $MAXN 1 random
generate $MAXN $MAXK random
generate $MAXN $MAXK increaseBoth
generate $MAXN $MAXK increaseX
generate $MAXN $MAXK increaseY
generate $MAXN 1 fewturns1
generate $MAXN 2 fewturns1
generate $(($MAXN - 1)) 1 random
generate $(($MAXN - 1)) $MAXK increaseBoth
generate $(($MAXN - 1)) 1 fewturns1
generate $(($MAXN - 1)) 2 fewturns1
generate $MAXN $MAXK fewturns20
generate $MAXN $MAXK fewturns40
generate $MAXN $MAXK fewturns60
generate $MAXN $MAXK fewturns100



# generate solutions for all files
if [[ ! -z $SOLVER ]]
then
    for i in ${subfolders[@]}
    do
        for f in $i/*.in
        do
            echo "solving $f"
            $SOLVER < $f > ${f%???}.ans
        done
    done
fi
