#!/usr/bin/env python3
import sys, argparse, random, math

parser = argparse.ArgumentParser(description="Generator for drivesafe.")    
parser.add_argument('-n', metavar='N', type=int, required=True,
                    help='number points in polyline')
parser.add_argument('-k', metavar='K', type=int, required=True,
                    help='number of signs')
parser.add_argument('-o', metavar='O', type=str, default="random",
                    help='options')
parser.add_argument('-s', metavar='S', type=int, default=None,
                    help='seed')
args = parser.parse_args()
random.seed(args.s)

MAXCOOR = 1000000

n = args.n
k = args.k
options = args.o

def getAngle(a, b, c):
    return 0
    ## Pretend b is in origo. Now find angle ab, subtract angle bc.
    ang_ab = math.atan2(a[1] - b[1], a[0] - b[0])
    ang_bc = math.atan2(c[1] - b[1], c[0] - b[0])
    ang = 180 - math.degrees(ang_ab - ang_bc)
    while (ang > 180):  ang -= 360
    while (ang < -180): ang += 360
    return ang

pline = []

if "increaseX" in options:
    
    for x in range(0, MAXCOOR, MAXCOOR // n):
        y = random.randrange(-MAXCOOR, MAXCOOR+1)
        pline.append((float(x), float(y)))
        
        while len(pline) > 2 and abs(getAngle(pline[-3], pline[-2], pline[-1])) >= 179:
            pline.pop()
            y = random.randrange(-MAXCOOR, MAXCOOR+1)
            pline.append((float(x), float(y)))
            
elif "increaseY" in options:
    ys = random.sample(range(-MAXCOOR, MAXCOOR+1), n)
    xs = random.sample(range(-MAXCOOR, MAXCOOR+1), n)
    ys.sort()
    
    for i in range(n):
        pline.append((xs[i], ys[i]))      
              
elif "increaseBoth" in options:
    ys = random.sample(range(-MAXCOOR, MAXCOOR+1), n)
    xs = random.sample(range(-MAXCOOR, MAXCOOR+1), n)
    ys.sort()
    xs.sort()
    
    for i in range(n):
        pline.append((xs[i], ys[i]))
        
            
elif "fewturns" in options:
    t = int("".join(filter(str.isdigit, options)))
    assert(t < n - 2)
    
    orgline = []

    for _ in range(t+2):
        x = random.randrange(-MAXCOOR, MAXCOOR+1)
        y = random.randrange(-MAXCOOR, MAXCOOR+1)
        orgline.append((float(x), float(y)))
        
        while len(pline) > 2 and not (1 < abs(getAngle(pline[-3], pline[-2], pline[-1])) < 179):
            x = random.randrange(-MAXCOOR, MAXCOOR+1)
            y = random.randrange(-MAXCOOR, MAXCOOR+1)
            orgline.append((float(x), float(y)))
    
    counter = [0] * (t+1)
    for _ in range(n-t-2):
        counter[random.randrange(t+1)] += 1
        
    for i in range(t+1):
        (ax, ay), (bx, by) = orgline[i], orgline[i+1]
        divs = counter[i]
        pline.append((ax, ay))
        for j in range(1, divs+1):
            # transpose a and b to origo
            bxp, byp = bx - ax, by - ay
            x = j * bxp / (divs + 1)
            y = j * byp / (divs + 1)
            # transpose point back
            pline.append((x + ax, y + ay))
            
    pline.append(orgline[-1])
    
else:
    for _ in range(n):
        x = random.randrange(-MAXCOOR, MAXCOOR+1)
        y = random.randrange(-MAXCOOR, MAXCOOR+1)
        pline.append((float(x), float(y)))
        
        while len(pline) > 2 and abs(getAngle(pline[-3], pline[-2], pline[-1])) >= 179:
            x = random.randrange(-MAXCOOR, MAXCOOR+1)
            y = random.randrange(-MAXCOOR, MAXCOOR+1)
            pline.append((float(x), float(y)))



print(n, k)
for a, b in pline:
    print("{:.6f} {:.6f}".format(a, b))
