#!/bin/bash

# Set the problem name to generate correct file names
PROBLEMNAME="periodticket"

# Set this if you want to generate answers.
g++ -O2 ../../submissions/accepted/torstein_n.cpp -o /tmp/a.out
SOLVER=/tmp/a.out
MAXN=1000000
MAXR=1000000000

subfolders=(generated) # (folderA folderB folderC)
for i in ${subfolders[@]}
do
    rm -r $i
    if [ ! -d $i ]
    then
        mkdir $i
    fi
done

COUNT=0
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    ./gendata.py -seed $COUNT -s $1 -p $2 -m $3 -n $4 -r $5 -o $6 > $DR/${padCount}_s$1_p$2_m$3_n$4_r$5_$6.in
}

echo "Generating dataset 1..."
DR="generated"

# (s)ingle price, (p)eriod price, (m) duration, (n) trips, (r)ange, (o)ptions
# Hardest to decide when s/(r/n) ~ p/m  (or s * m * n >~ p * r)
generate 38 780 30 50 30 random
generate 38 780 30 50 50 random
generate 38 780 30 50 60 random
generate 38 780 30 50 70 random
generate 38 780 30 50 80 random
generate 38 780 30 50 90 random

generate 391 1139 2600 $MAXN $MAXR random
generate 391 1139 2700 $MAXN $MAXR random
generate 391 1139 2800 $MAXN $MAXR random
generate 391 1139 2900 $MAXN $MAXR random
generate 391 1139 3000 $MAXN $MAXR random
generate 391001 1139009 3100 $MAXN $MAXR random
generate 391001 1139009 3200 $MAXN $MAXR random
generate 391001 1139009 3300 $MAXN $MAXR random
generate 999999999 1000000000 1 $MAXN $MAXR random

# echo "Generating dataset 2... (b_circle)"
# DR="foldername"
#
# generate 7 50 circle_noshuffle



# generate solutions for all files
if [[ ! -z $SOLVER ]]
then
    for i in ${subfolders[@]}
    do
        for f in $i/*.in
        do
            echo "solving $f"
            $SOLVER < $f > ${f%???}.ans
        done
    done
fi