#include <iostream>
#include <cmath>

using namespace std;

#define ll long long

/*
T = Train TA
G = Grade
Example: with 6 TAs and 5 totalTime, we can grade 15 exams:
    1         T
    2     T       T
    3   T   T   T   G
    4  G G G G G G  G
    5  G G G G G G  G
completeLevels = 2 (= ⌊log₂(6 + 1)⌋)
overflowLevel  = 6 (= 2 * (6 - (2 ^ 2 - 1)))
previousLevel  = 1 (= 2 ^ 2 - 6 / 2)
return 1 * (5 - 2) + 6 * (5 - 2 - 1)
*/
ll numExamsThatCanBeGraded(ll totalTime, ll numTAs) {
    // complete_levels = int(log2(num_TAs + 1))
    // overflow_level = 2 * (num_TAs - (2 ** complete_levels - 1))
    // previous_level = 2 ** complete_levels - overflow_level // 2
    // return previous_level * (total_time - complete_levels) + overflow_level * (total_time - complete_levels - 1)
    ll completeLevels = (ll) (log(numTAs + 1) / log(2));
    ll overflowLevel = 2 * (numTAs - (ll) pow(2, completeLevels) + 1);
    ll previousLevel = (ll) pow(2, completeLevels) - overflowLevel / 2;
    return previousLevel * (totalTime - completeLevels) + overflowLevel * (totalTime - completeLevels - 1);
}

int main() {
    int n, t;
    cin >> n >> t;

    if (t == 0 || n == 0) {
        cout << "0 0" << endl;
        return 0;
    }
    if (n == 1) {
        cout << t << " 1" << endl;
        return 0;
    }

    ll totalTime = (ll) (log(n - 1) / log(2)) + 2;

    ll low = 0;
    ll high = n - 1;
    while (low < high) {
        ll mid = (low + high) / 2;
        if (numExamsThatCanBeGraded(totalTime, mid) >= n)
            high = mid;
        else
            low = mid + 1;
    }

    cout << (totalTime * t) << " " << (high + 1) << endl;
}
