import java.io.*;
import java.util.*;

public class MaartenGradingBinSearch {
    public static void main(String[] args) {
        try (Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)))) {
            new MaartenGradingBinSearch().run(sc);
        }
    }

    public void run(Scanner sc) {
        int n = sc.nextInt();
        int t = sc.nextInt();

        if (t == 0 || n == 0) {
            System.out.println("0 0");
            return;
        }
        if (n == 1) {
            System.out.println(t + " 1");
            return;
        }

        long totalTime = (long) (Math.log(n - 1) / Math.log(2)) + 2;

        long low = 0;
        long high = n - 1;
        while (low < high) {
            long mid = (low + high) / 2;
            if (numExamsThatCanBeGraded(totalTime, mid) >= n)
                high = mid;
            else
                low = mid + 1;
        }

        System.out.println((totalTime * t) + " " + (high + 1));
    }

    /*
    T = Train TA
    G = Grade
    Example: with 6 TAs and 5 totalTime, we can grade 15 exams:
        1         T
        2     T       T
        3   T   T   T   G
        4  G G G G G G  G
        5  G G G G G G  G
    completeLevels = 2 (= ⌊log₂(6 + 1)⌋)
    overflowLevel  = 6 (= 2 * (6 - (2 ^ 2 - 1)))
    previousLevel  = 1 (= 2 ^ 2 - 6 / 2)
    return 1 * (5 - 2) + 6 * (5 - 2 - 1)
    */
    private long numExamsThatCanBeGraded(long totalTime, long numTAs) {
        // complete_levels = int(log2(num_TAs + 1))
        // overflow_level = 2 * (num_TAs - (2 ** complete_levels - 1))
        // previous_level = 2 ** complete_levels - overflow_level // 2
        // return previous_level * (total_time - complete_levels) + overflow_level * (total_time - complete_levels - 1)
        long completeLevels = (long) (Math.log(numTAs + 1) / Math.log(2));
        long overflowLevel = 2 * (numTAs - (long) Math.pow(2, completeLevels) + 1);
        long previousLevel = (long) Math.pow(2, completeLevels) - overflowLevel / 2;
        return previousLevel * (totalTime - completeLevels) + overflowLevel * (totalTime - completeLevels - 1);
    }
}
