h, w = [int(x) for x in input().split()]
grid = [input().strip() for _ in range(h)]

valid = {(x, y) for y, row in enumerate(grid) for x, c in enumerate(row) if c == "D"}
visited = set(valid)
stack = set(valid)
while stack:
    next_stack = set()
    for x, y in stack:
        for dx, dy in [(-1, 0), (1, 0), (0, 1), (0, -1)]:
            new_x = x + dx
            new_y = y + dy
            new = (new_x, new_y)
            if new in visited:
                continue
            visited.add(new)
            # This solution can only walk boxes straight ahead, and cannot take corners
            if 0 <= new_y + dy < h and 0 <= new_x + dx < w and \
                    grid[new_y][new_x] == grid[new_y + dy][new_x + dx] == ".":
                valid.add(new)
                next_stack.add(new)
    stack = next_stack

for y in range(h):
    print("".join("O" if (x, y) in valid else "X" for x in range(w)))
