DIRS = [(-1, 0), (1, 0), (0, 1), (0, -1)]

h, w = [int(x) for x in input().split()]
grid = [input().strip() for _ in range(h)]

valid = {(x, y) for y, row in enumerate(grid) for x, c in enumerate(row) if c == "D"}
todo = set()


def tile(pos):
    return grid[pos[1]][pos[0]]


def explore_neighbours(pos):
    x, y = pos
    for dx, dy in DIRS:
        new_pos = (x + dx, y + dy)
        if tile(new_pos) == "." and new_pos not in valid:
            todo.add(new_pos)


for pos in valid:
    explore_neighbours(pos)

while todo:
    curr_pos = todo.pop()
    x, y = curr_pos
    for dx, dy in DIRS:
        from_pos = (x + dx, y + dy)
        to_pos = (x - dx, y - dy)
        if to_pos in valid and tile(from_pos) != "#":
            valid.add(curr_pos)
            explore_neighbours(curr_pos)

for y in range(h):
    print("".join("O" if (x, y) in valid else "X" for x in range(w)))
