import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Scanner;

public class D_Correct {
	public static void main(String[] args) {
		Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
		new D_Correct().run(sc);
		sc.close();
	}

	public void run(Scanner sc) {
		int n = sc.nextInt();
		sc.nextLine();

		double h1 = sc.nextDouble();
		double h2 = sc.nextDouble();
		double h3 = sc.nextDouble();
		sc.nextLine();

		double v1 = sc.nextDouble();
		double v2 = sc.nextDouble();
		double v3 = sc.nextDouble();
		sc.nextLine();

		int hits = 0;
		
		double n1 = h2 * v3 - v2 * h3,
					 n2 = h3 * v1 - v3 * h1,
					 n3 = h1 * v2 - v1 * h2;

		for (int i = 0; i < n; i++) {
			double p1 = sc.nextDouble();
			double p2 = sc.nextDouble();
			double p3 = sc.nextDouble();

			double d1 = sc.nextDouble();
			double d2 = sc.nextDouble();
			double d3 = sc.nextDouble();
			
			sc.nextLine();

			double dProjection = d1 * n1 + d2 * n2 + d3 * n3;

			if (Math.abs(dProjection) < 1e-4) continue;
	
			double pProjection = p1 * n1 + p2 * n2 + p3 * n3;
			double length = -pProjection / dProjection;
	
			if (length < 0) continue;

			double i1 = p1 + d1 * length;
			double i2 = p2 + d2 * length;
			double i3 = p3 + d3 * length;

			double hFactor = (i1 * h1 + i2 * h2 + i3 * h3) / (h1 * h1 + h2 * h2 + h3 * h3);
			double vFactor = (i1 * v1 + i2 * v2 + i3 * v3) / (v1 * v1 + v2 * v2 + v3 * v3);
			if ((hFactor * hFactor + vFactor * vFactor) < 1) hits++;
		}
		System.out.println(hits);
	}

}
