import java.io.BufferedInputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Scanner;

/**
 * Created by Laurens on 28-1-2016.
 */
public class SKP2016CSolutionSubOptimal {
    public static void main(String[] args) {
        Scanner sc = new Scanner(new BufferedInputStream(System.in));
        // Set this to read points in floats instead of commas.
        sc.useLocale(Locale.ENGLISH);
        new SKP2016CSolutionSubOptimal().solve(sc);
    }

    // O(n log n)
    private void solve(Scanner sc) {
        int SKPLength = sc.nextInt();
        int numberOfStudents = sc.nextInt();
        float bestTimeMeasured = sc.nextFloat();

        float[] times = new float[numberOfStudents];

        for (int i = 0; i < numberOfStudents; i++) {
            float frontCrawlSpeed = sc.nextFloat();
            float backCrawlSpeed = sc.nextFloat();
			
			float sec = (SKPLength / frontCrawlSpeed) + (SKPLength / backCrawlSpeed);

            times[i] = sec;
        }

        Arrays.sort(times);

        float fastestStudent = times[0];

        // Don't forget that you have to return!
        if(fastestStudent < bestTimeMeasured) {
            System.out.println("HOPE");
        } else {
            System.out.println("DOOMED");
        }
    }
}
