import java.util.*;

/**
 * @author Martijn den Hoedt
 * @version 1.0
 * @since 2016-01-03
 */

public class A {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        solve(sc);
    }

    static class Score {
        public int home_score, guest_score;

        public Score(String str) {
            String[] temp = str.split("-");
            home_score = Integer.parseInt(temp[0]);
            guest_score = Integer.parseInt(temp[1]);
        }

        public String toString() {
            return home_score + "-" + guest_score;
        }

        /**
         * @return false if one score itself is inconsitent.
         */
        public boolean isConsistent() {
            if (home_score > 11 || guest_score > 11)
                return Math.abs(home_score - guest_score) <= 2;
            return true;
        }

        /**
         * @return true if the game has a winner
         */
        public boolean hasWinner() {
            if(home_score >= 11 || guest_score >= 11)
                return Math.abs(home_score - guest_score) >= 2;
            return false;
        }

        /**
         * @return 1 if the home player has won this game, returns 0 otherwise.
         */
        public int homeWon() {
            if(home_score >= 11 && home_score - guest_score >= 2) 
                return 1;
            return 0;
        }

        /**
         * @return is 1 if the guest player has won this game, returns 0
         * otherwise.
         */
        public int guestWon() {
            if(guest_score >= 11 && guest_score - home_score >= 2)
                return 1;
            return 0;
        }

        /**
         * @param n this is the n-th game.
         * @return true if the home player is serving, returns false otherwise.
         */
        public boolean homeServing(int n) {
            int total_points = guest_score + home_score;
            if (total_points <= 20) 
                return ((total_points / 2 + n - 1) % 2) == 0;
            return (total_points - 20 + n - 1) % 2 == 0;
        }
    }

    /**
     * Solves the problem after reading the input.
     * @param sc this method also reads the input.
     */
    static void solve(Scanner sc) {
        int n = sc.nextInt(); // number of games
        Score[] scores = new Score[n];
        boolean consistent = true;
        boolean previousWon = true;
        int homePoints = 0, guestPoints = 0;

        for (int i = 0; i < n; i++) {
            // if the previous game has no winner, or if the set is already
            // decided, there can't be a new game. However there is a new game
            // so the score board is INCONSISTENT.
            if (!previousWon || homePoints >= 3 || guestPoints >= 3)
                consistent = false;
            scores[i] = new Score(sc.next());
            consistent &= scores[i].isConsistent();
            previousWon = scores[i].hasWinner();
            homePoints += scores[i].homeWon();
            guestPoints += scores[i].guestWon();
        }

        // print the output
        if (!consistent) {
            System.out.println("INCONSISTENT");
            return;
        } else if (scores[n - 1].homeServing(n)) {
            System.out.println("HOST");
        } else {
            System.out.println("GUEST");
        }
    }
}
