// Solution to Extreme Shopping
// Author: Thomas Beuman

// Time complexity: O(n*m)
// Memory: O(n)

// @EXPECTED_RESULTS@: CORRECT

/*
Solution method: dynamic programming

Sort all shops by their price per item; consider cheapest shop first.
Using DP, find the minimum amount of money needed to get w wickets from the first s shops.
For each new shop, consider buying nothing or buying as much as possible.
*/

#include <cstdio>
#include <algorithm>
#include <cstring>
using namespace std;

struct shop
{ int stock, itemprice, orderprice;
};

bool operator < (shop A, shop B)
{ return A.itemprice < B.itemprice;
}

shop S[10000];
int Money[10001];

int main()
{ int cases, casenr, n, m, i, j, t;
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { scanf("%d %d\n", &n, &m);
    for (i = 0; i < m; i++)
      scanf("%d %d %d\n", &S[i].stock, &S[i].itemprice, &S[i].orderprice);
    sort(S, S+m);
    memset(Money, 63, sizeof(Money)); // Set to "infinity"
    Money[0] = 0;
    for (i = 0; i < m; i++) // i = current shop
      for (j = n-1; j >= 0; j--) // j = amount of wickets (processed in reverse to avoid raiding a shop more than once)
        // t = new amount of wickets after looting shop i
        Money[t = min(n, j + S[i].stock)] = min(Money[t], Money[j] + S[i].orderprice + (t-j)*S[i].itemprice);
    printf("%d\n", Money[n]);
  }
  return 0;
}

