// Solution to Extreme Shopping
// Author: Thomas Beuman

// Time complexity: O(n*m)
// Memory: O(n)

// @EXPECTED_RESULTS@: WRONG-ANSWER

/*
Solution method: greedy

Buy as many wickets as possible from the shop with the lowest average price (including order price).
Repeat until we have the desired number of wickets.
*/

#include <cstdio>
#include <algorithm>
using namespace std;

struct shop
{ int stock, itemprice, orderprice;
};

shop S[10000];

int main()
{ int cases, casenr, n, m, i, s, money;
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { // Read input
    scanf("%d %d\n", &n, &m);
    for (i = 0; i < m; i++)
      scanf("%d %d %d\n", &S[i].stock, &S[i].itemprice, &S[i].orderprice);
    money = 0;
    // Repeat while we still have wickets to buy
    while (n > 0)
    { // Set the stock to the maximum number of items we can buy / need
      for (i = 0; i < m; i++)
        S[i].stock = min(S[i].stock, n);
      // Look for shop with lowest average price per wicket,
      // i.e. with the lowest value of (orderprice + stock * itemprice) / stock
      s = -1;
      for (i = 0; i < m; i++)
        if (S[i].stock > 0 && (s == -1 ||
            (long long)S[s].stock * (S[i].orderprice + S[i].stock * S[i].itemprice) <
            (long long)S[i].stock * (S[s].orderprice + S[s].stock * S[s].itemprice)))
          s = i;
      // Buy as many as possible
      money += S[s].orderprice + S[s].stock * S[s].itemprice;
      n -= S[s].stock;
      S[s].stock = 0;
    }
    // Output
    printf("%d\n", money);
  }
  return 0;
}

