// Solution to Digital Transmission
// Author: Thomas Beuman

// Time complexity: O(n)
// Memory: O(n)

// @EXPECTED_RESULTS@: CORRECT

/*
Solution method: greedy

First check if there are already conflicts in the code or forced choices.
Then, try to fill the code with as many 1's as possible, by entering a 1
whenever there is a "free" choice. See if this results in enough 1's.
The same for the 0's. If this also gives enough 0's, output "yes".

Assumptions: (i.e. not proved/disproved yet)
- If n is even, and there is a solution with enough 1's and one with enough 0's,
  there is a solution with the right number of 1's and 0's.
- If there are no bits forced "locally", i.e. based on their 4 nearest neighbors,
  nothing is forced at all.
- If one wants to use as many 1's as possible, one can get this by setting any bit to 1
  every time there is no forced choice.
*/

#include <cstdio>
#include <cstring>
using namespace std;

int n;
int Code[100000], Code2[100000];

// See if Code[i] is forced by its neighbors; if not, set to preferred value (pref)
bool check (int i, int pref)
{ if (i < 0 || i >= n) // Out of bounds
    return true;
  int forced_value = 0;
  // See if Code[i] is forced by the neighbors
  if (i > 1 && Code[i-1]*Code[i-2] == 1) // Check if the two bits on the left are the same
    forced_value = -Code[i-1];
  if (i < n-2 && Code[i+1]*Code[i+2] == 1) // Check the two bits on the right
  { if (Code[i+1] == forced_value) // Situation 00*11 or 11*00
      return false;
    forced_value = -Code[i+1];
  }
  if (i > 0 && i < n-1 && Code[i+1]*Code[i-1] == 1) // Check the two adjacent bits
    forced_value = -Code[i+1];
  if (Code[i] == 0) // If Code[i] has not yet been set
  { Code[i] = (forced_value != 0 ? forced_value : pref); // Set Code[i] to forced value or preferred value
    // If Code[i] was set, check the neighbors
    return Code[i] == 0 || (check(i-1, pref) && check(i-2, pref) && check(i+1, pref) && check(i+2, pref));
  }
  return forced_value != -Code[i]; // Code[i] was already set; check if there is no conflict
}

// Returns the number of 1-bits (stored as 1) minus the number of 0-bits (stored as -1)
int sum()
{ int s = 0, i;
  for (i = 0; i < n; i++)
    s += Code[i];
  return s;
}

int main()
{ int cases, casenr, i;
  char buf[100001];
  bool possible;
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { // Read input
    scanf("%s\n", buf);
    for (n = 0; buf[n] != '\0'; n++)
      Code[n] = (buf[n] == '1' ? 1 : buf[n] == '0' ? -1 : 0);
      // Store 1-bit as 1, 0-bit as -1 and no bit as 0
    // Check if there is an odd number of bits
    if (n % 2)
    { printf("This is not supposed to happen!\n");
      continue;
    }
    possible = true;
    // Look for forced bits or existing conflicts
    for (i = 0; possible && i < n; i++)
      possible &= check(i, 0);
    memcpy(Code2, Code, n*sizeof(int)); // Store current code
    // Try using 1-bits as much as possible
    for (i = 0; possible && i < n; i++)
      possible &= check(i, 1);
    possible &= (sum() >= 0); // Check if there are enough 1-bits
    memcpy(Code, Code2, n*sizeof(int)); // Store current code
    // Try using 0-bits as much as possible
    for (i = 0; possible && i < n; i++)
      possible &= check(i, -1);
    possible &= (sum() <= 0); // Check if there are enough 0-bits
    printf("%s\n", possible ? "yes" : "no");
  }
  return 0;
}

