#include <cassert>
#include <iostream>
#include <vector>
using namespace std;

int main() {
	int w, h;
	cin >> w >> h;

	vector<vector<bool>> filtered(w + 1, vector<bool>(h + 1, false));

	auto random_point = [&] {
		for(int x = 1; x <= w; ++x)
			for(int y = 2; y < h; ++y)
				if(not filtered[x][y]) return pair<int, int>{x, y};
		assert(false);
	};

	vector<pair<int, int>> ans;
	while(ans.size() < 2) {
		auto [qx, qy] = random_point();
		cout << "? " << qx << ' ' << qy << endl;
		string s;
		cin >> s;
		if(s == "horizon") {
			ans.emplace_back(qx, qy);
			filtered[qx][qy] = true;
			continue;
		}
		if(s == "sea") {
			for(int y = 1; y <= qy; ++y) filtered[qx][y] = true;
			for(int x = 1; x < qx; ++x)
				for(int y = 1; (y - 1) * (qx - 1) <= (qy - 1) * (x - 1); ++y) filtered[x][y] = true;
			for(int x = qx + 1; x <= w; ++x)
				for(int y = 1; (y - 1) * (w - qx) <= (qy - 1) * (w - x); ++y) filtered[x][y] = true;
		}
		if(s == "sky") {
			for(int y = qy; y <= h; ++y) filtered[qx][y] = true;
			for(int x = 1; x < qx; ++x)
				for(int y = 1; (h - y) * (qx - 1) <= (h - qy) * (x - 1); ++y) filtered[x][y] = true;
			for(int x = qx + 1; x <= w; ++x)
				for(int y = 1; (h - y) * (w - qx) <= (h - qy) * (w - x); ++y) filtered[x][y] = true;
		}
	}

	cout << "! " << ans[0].first << ' ' << ans[0].second << ' ' << ans[1].first << ' '
	     << ans[1].second;
}
