// Solution to Hex
// Author: Thomas Beuman

// Time complexity: O(n^2)
// Memory: O(n^2)

// @EXPECTED_RESULTS@: CORRECT

// Solution method: Breadth-first search

#include <cstdio>
#include <cstring>
using namespace std;

enum {neither, black, white};

char Board[100][101];
int BFSqueue[10100][2];
bool Seen[100][100];
int di[6] = {0,0,1,-1,1,-1};
int dj[6] = {1,-1,0,0,-1,1};

int main()
{ int cases, casenr, n, i, j, i2, j2, k, p, current, last, winner;
  char color;
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { // Read input
    scanf("%d\n", &n);
    for (i = 0; i < n; i++)
      scanf("%s\n", Board[i]);
    winner = neither;
    for (p = 0; p < 2; p++) // For both players
    { color = (p == 0 ? 'B' : 'W');
      if (p == 0)
        // For black: put the top edge (top left edge of the diamond) on the BFS queue
        for (j = 0; j < n; j++)
        { BFSqueue[j][0] = -1;
          BFSqueue[j][1] = j;
        }
      else
        // For white: put the left edge (bottom left edge of the diamond) on the BFS queue
        for (i = 0; i < n; i++)
        { BFSqueue[i][0] = i;
          BFSqueue[i][1] = -1;
        }
      last = n;
      memset(Seen, false, sizeof(Seen));
      // Look for a path to the other side using BFS
      for (current = 0; current < last && winner == neither; current++)
      { // Take next cell from the BFS queue
        i = BFSqueue[current][0];
        j = BFSqueue[current][1];
        // Try all six directions
        for (k = 0; k < 6; k++)
        { i2 = i + di[k];
          j2 = j + dj[k];
          // Check if it has the right color and hasn't been processed yet
          if (i2 >= 0 && i2 < n && j2 >= 0 && j2 < n && Board[i2][j2] == color && !Seen[i2][j2])
          { if ((p == 0 && i2 == n-1) || (p == 1 && j2 == n-1)) // black: bottom edge; white: right edge
              winner = (p == 0 ? black : white);
            // Add to BFS queue
            Seen[i2][j2] = true;
            BFSqueue[last][0] = i2;
            BFSqueue[last][1] = j2;
            last++;
          }
        }
      }
    }
    printf("%s\n", winner == black ? "Black wins" : winner == white ? "White wins" : "Not finished");
  }
  return 0;
}

