// @EXPECTED_RESULTS@: CORRECT
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static void fill(int N, char grid[N][N], char s, char t, int r, int c)
{
    if (r < 0 || c < 0 || r >= N || c >= N || grid[r][c] != s) return;
    grid[r][c] = t;
    fill(N, grid, s, t, r - 1, c    );
    fill(N, grid, s, t, r - 1, c + 1);
    fill(N, grid, s, t, r,     c - 1);
    fill(N, grid, s, t, r,     c + 1);
    fill(N, grid, s, t, r + 1, c    );
    fill(N, grid, s, t, r + 1, c - 1);
}

int main()
{
    char line[1024];
    fgets(line, sizeof(line), stdin);
    int cases = atoi(line);
    while (cases-- > 0)
    {
        fgets(line, sizeof(line), stdin);
        int n, N = atoi(line);
        char grid[N][N];
        for (n = 0; n < N; ++n)
        {
            fgets(line, sizeof(line), stdin);
            memcpy(grid[n], line, N);
        }
        for (n = 0; n < N; ++n)
        {
            fill(N, grid, 'B', 'b', 0, n);
            fill(N, grid, 'W', 'w', n, 0);
        }
        const char *result = "Not finished";
        for (n = 0; n < N; ++n)
        {
            if (grid[n][N - 1] == 'w') result = "White wins";
            if (grid[N - 1][n] == 'b') result = "Black wins";
        }
        puts(result);
    }
    return 0;
}
