/*
 * Solution to Gunslinger
 * Author: Bas den Heijer
 * 
 * Time: O(n log n)
 * 
 * @EXPECTED_RESULTS@: CORRECT
 * 
 */

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import java.util.Scanner;

class bas {
	
	private static Scanner sc;

	public static void main(String[] args) {
		sc = new Scanner(System.in);
		int n = sc.nextInt();
		for (int i=0; i<n; i++)
			doShizzle();
	}

	private static void doShizzle() {
		Point lukePos = readPos();
		Point hatchPos = readPos();
		int nrDaltons = sc.nextInt();
		ArrayList<Point> points = new ArrayList<Point>(nrDaltons + 2);
		
		for (int i=0; i<nrDaltons; i++)
			points.add(readPos());
		
		// Possible iff luke and the hatch are not strictly in the convex hull of the daltons
		// If point x lies outside the hull, it will be on the hull of daltons+x
		points.add(lukePos);
		boolean lukeOutside = convexhull(points.toArray(new Point[nrDaltons+1])).contains(lukePos);
		points.remove(nrDaltons);
		points.add(hatchPos);
		boolean hatchOutside = convexhull(points.toArray(new Point[nrDaltons+1])).contains(hatchPos);
		points.remove(nrDaltons);
		
		if (lukeOutside && hatchOutside) {
			// It's possible, two options remain: either Luke can walk directly or he has to traverse part of the hull
			// In the latter case both luke and the hatch should be on the convex hull of all the points
			points.add(lukePos);
			points.add(hatchPos);
			ArrayList<Point> hull = convexhull(points.toArray(new Point[nrDaltons+2]));
			
			double pathLength;
			if (hull.contains(lukePos) && hull.contains(hatchPos)) {
				// So Luke has to traverse part of the hull
				
				// Add first point to end for easy length calculation
				hull.add(hull.get(0));
				
				double hullLength = 0;
				pathLength = 0;
				boolean seenLuke = false, seenHatch = false;
				for (int i=0; i<hull.size()-1; i++) {
					Point p = hull.get(i);
					seenLuke |= p == lukePos;
					seenHatch |= p == hatchPos;
					
					hullLength += dist(p, hull.get(i+1));
					if (seenLuke ^ seenHatch) pathLength += dist(p, hull.get(i+1));
				}
				
				pathLength = Math.min(pathLength, hullLength-pathLength);
			} else {
				pathLength = dist(lukePos, hatchPos);
			}
			
			//System.out.printf("%.3f\n",pathLength); // Alleen goed als Locale goed is ingesteld (Geeft anders , ipv .)
			new Formatter(System.out, Locale.US).format("%.3f\n", pathLength); // Werkt altijd
		} else {
			System.out.print("IMPOSSIBLE\n");
		}
	}
	
	private static double dist(Point a, Point b) {
		return Point2D.Double.distance(a.x, a.y, b.x, b.y);
	}

	// Andrew's monotone chain: O(n log n)
	// Will include redundant points in the list (lying on a hull segment)
	private static ArrayList<Point> convexhull(Point[] points) {
		Arrays.sort(points);


		// Build lower hull
		ArrayList<Point> lowerHull = new ArrayList<Point>();
		for (int i = 0; i < points.length ; i++) {
			while (lowerHull.size() >= 2 && leftTurn(lowerHull.get(lowerHull.size()-2), lowerHull.get(lowerHull.size()-1), points[i]))
				lowerHull.remove(lowerHull.size()-1);
			lowerHull.add(points[i]);
		}

		// Build upper hull
		ArrayList<Point> upperHull = new ArrayList<Point>();
		for (int i = points.length-1; i >= 0 ; i--) {
			while (upperHull.size() >= 2 && leftTurn(upperHull.get(upperHull.size()-2), upperHull.get(upperHull.size()-1), points[i]))
				upperHull.remove(upperHull.size()-1);
			upperHull.add(points[i]);
		}
		
		lowerHull.remove(lowerHull.size()-1);
		upperHull.remove(upperHull.size()-1);
		
		lowerHull.addAll(upperHull);
		return lowerHull;
	}
	
	private static boolean leftTurn(Point base, Point mid, Point last) {
		return Line2D.Double.relativeCCW(base.x, base.y, mid.x, mid.y, last.x, last.y) <= 0;
	}

	private static Point readPos() {
		Point p = new Point();
		p.x = sc.nextInt();
		p.y = sc.nextInt();
		return p;
	}
	
	static class Point implements Comparable<Point> {
		int x;
		int y;
		
		@Override
		public int compareTo(Point o) {
			return x==o.x ? y - o.y : x - o.x;
		}
	}
}
