// Solution to Annoying Mosquitos
// Author: Thomas Beuman

// Time complexity: O(n*m)
// Memory: O(n)

// @EXPECTED_RESULTS@: TIMELIMIT

// Solution method: simulate all swats

#include <cstdio>
#include <cstring>
#include <algorithm>
using namespace std;

int X[100], Y[100];
bool Hit[2001][2001];

int main()
{ int cases, casenr, n, m, i, j, x, y, t, begin, length;
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { // Read input
    scanf("%d\n", &n);
    for (i = 0; i < n; i++)
    { scanf("%d %d\n", &x, &y);
      X[i] = 1000 + x;
      Y[i] = 1000 + y;
    }
    scanf("%d\n", &m);
    // Simulate all swats
    memset(Hit, false, sizeof(Hit));
    for (j = 0; j < m; j++)
    { scanf("%d %d\n", &x, &y);
      x += 1000;
      y += 1000;
      begin = max(y-50, 0);
      length = min(y+50, 2000) - begin + 1;
      for (i = max(x-50, 0); i <= x+50 && i <= 2000; i++)
        memset(&Hit[i][begin], true, length * sizeof(bool));
    }
    // Count the number of dead mosquitos
    t = 0;
    for (i = 0; i < n; i++)
      if (Hit[X[i]][Y[i]])
        t++;
    printf("%d\n", t);
  }
  return 0;
}

