// Worst case complexity: O(s * e)

import java.util.*;
import java.io.*;

public class jeroen {
    public static void main(String[] args) throws Exception {
	// Read input
	BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
	String[] ps = in.readLine().split(" ");
	int s = Integer.valueOf(ps[0]);
	int e = Integer.valueOf(ps[1]);
	int[] ws = new int[e];
	for(int i = 0; i < e; i++)
	    ws[i] = Integer.valueOf(in.readLine());

	// Solve subset sum
	boolean[] can = new boolean[s+1];
	int[] lastw = new int[s+1];
	can[0] = true;

	for(int i = 0; i < e; i++) {
	    for(int j = s; j >= 0; j--) {
		if(!can[j]) continue;
		if(j+ws[i] > s || can[j+ws[i]]) continue;

		can[j+ws[i]] = true;
		lastw[j+ws[i]] = i;
	    }
	}

	// double check
	if(!can[s]) throw new Exception("I was promised that there would be a solution!");

	// Start output, we always use e+1 edges
	System.out.println(e+1);

	// Retrace which edges we use for the shortest path and output that path
	boolean[] used = new boolean[e];
	int curs = s;
	int curn = 1;
	while(curs != 0) {
	    used[lastw[curs]] = true;
	    int cure = ws[lastw[curs]];
	    int nexts = curs - cure;
	    int nextn = nexts == 0 ? 2 : curn == 1 ? 3 : curn + 1;
	    System.out.println(curn + " " + nextn + " " + cure);
	    curs = nexts;
	    curn = nexts == 0 ? curn + 1 : nextn;
	}
	if(curn == 2) curn++;

	// Redirect the rest of the edges to other nodes such that they have no influence
	// on the shortest path
	for(int i = 0; i < e; i++) {
	    if(used[i]) continue;
	    System.out.println("1 " + curn + " " + ws[i]);
	    curn++;
	}
    }
}
