#include <cstdio>
#include <cstdlib>
#include <cassert>
#include <iostream>
#include <set>
#include <vector>
#include <cstring>
#include <string>
#include <algorithm>
#include <numeric>
#include <cmath>
#include <complex>
#include <map>
using namespace std;
typedef long long ll;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef vector<vi> vvi;
typedef vector<vl> vvl;
typedef vector<double> vd;
typedef pair<int, int> pii;
typedef pair<double, double> pdd;
typedef vector<pii> vii;

inline ll mpow (ll x, int n) {
    if (n == 2) {
        return x*x;
    }
    if (n == 3) {
        return x*x*x;
    }
    if (n == 4) {
        ll y = x*x;
        return y*y;
    }
    assert(false);
}

const int MAXK = 4;
const int N = 500000;
ll v[MAXK][N];
ll s[MAXK][N];
vvi c(MAXK+1, vi(MAXK+1));

ll f(int n, int k) {
    if (n < N) {
        return s[k-1][n];
    }
    if (k == 1) {
        return n;
    }
    int m = 1;
    while (mpow(m+1, k) <= n) ++m;
    ll sum = 0, zn = 1;
    for (int i = 1; i < k; ++i) {
        ll cur = 0;
        if (i > 1) {
            for (int mask = 0; mask < mpow(m, i); ++mask) {
                int mask1 = mask, rem = n;
                for (int j = 0; j < i; ++j) {
                    rem /= ((mask1 % m) + 1);
                    mask1 /= m;
                }
                cur += f(rem, k - i);
            }
        } else {
            if (k == 2) {
                for (int x = 1; x <= m; ++x)
                    cur += n/x;
            } else {
                for (int x = 1; x <= m; ++x)
                    cur += f(n/x, k-1);
            }
        }
        sum += zn * c[i][k] * cur;
        zn *= -1;
    }
    return sum + zn*mpow(m, k);
}

int main() {
    c[0].assign(c.size(), 1);
    for (int i = 1; i < c.size(); ++i) for (int j = 1; j <= i; ++j)
        c[j][i] = c[j-1][i-1] + c[j][i-1];
    memset(v, 0, sizeof(v));
    memset(s, 0, sizeof(s));
    for (int i = 0; i < N; ++i) {
        v[0][i] = 1;
        s[0][i] = i;
    }
    for (int k = 1; k < MAXK; ++k) {
        for (int d = 1; d < N; ++d) for (int i = d; i < N; i += d) {
            v[k][i] += v[k-1][i/d];
        }
        for (int i = 1; i < N; ++i) {
            s[k][i] = s[k][i-1] + v[k][i];
        }
    }
    int T;
    scanf("%d", &T);
    assert(0 < T && T <= 100000);
    ll sumtest = 0;
    for (int test = 1; test <= T; ++test) {
        int n, k;
        scanf("%d%d", &n, &k);
        sumtest += n;
        assert(0 < n && sumtest <= 1000000000);
        assert(0 < k && k <= MAXK);
        printf("%lld\n", f(n, k));
    }
    return 0;
}
