import java.util.*;
import java.io.*;

public class m {
    class Graph {
        int[][] a;

        Graph(int n) {
            a = new int[n][n];
        }
    }

    Graph create(int[][] a) {
        if (a.length == 1) {
            return new Graph(1);
        }

        int n = a.length;
        int min = Integer.MAX_VALUE;
        int mini = 0;
        int minj = 0;
        for (int i = 0; i < n; i++) {
            for (int j = i + 1; j < n; j++) {
                if (a[i][j] < min) {
                    min = a[i][j];
                    mini = i;
                    minj = j;
                }
            }
        }

        int[] which = new int[n];
        which[mini] = 1;
        which[minj] = 2;

        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < n; i++) {
                for (int j = 0; j < n; j++) {
                    if (which[i] == 1 && which[j] == 0 && a[i][j] > min) {
                        changed = true;
                        which[j] = 1;
                    }
                    if (which[i] == 2 && which[j] == 0 && a[i][j] > min) {
                        changed = true;
                        which[j] = 2;
                    }
                }
            }
        }

        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                if (which[i] == 1 && which[j] == 2 && a[i][j] > min) {
                    return null;
                }
            }
        }

        for (int i = 0; i < n; i++) {
            if (which[i] == 0) {
                which[i] = 1;
            }
        }

        int n1 = 0;
        int n2 = 0;
        int[] p1 = new int[n];
        int[] p2 = new int[n];
        for (int i = 0; i < n; i++) {
            if (which[i] == 1) {
                p1[i] = n1++;
            } else {
                p2[i] = n2++;
            }
        }

        int[][] a1 = new int[n1][n1];
        int[][] a2 = new int[n2][n2];

        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                if (which[i] == 1 && which[j] == 1) {
                    a1[p1[i]][p1[j]] = a[i][j];
                }
                if (which[i] == 2 && which[j] == 2) {
                    a2[p2[i]][p2[j]] = a[i][j];
                }
            }
        }

        Graph g1 = create(a1);
        Graph g2 = create(a2);
        if (g1 == null || g2 == null) {
            return null;
        }

        int[] r1 = new int[n1];
        int[] r2 = new int[n2];
        for (int i = 0; i < n; i++) {
            if (which[i] == 1) {
                r1[p1[i]] = i;
            } else {
                r2[p2[i]] = i;
            }
        }

        Graph g = new Graph(n);
        for (int i = 0; i < n1; i++) {
            for (int j = 0; j < n1; j++) {
                g.a[r1[i]][r1[j]] = g1.a[i][j];
            }
        }
        for (int i = 0; i < n2; i++) {
            for (int j = 0; j < n2; j++) {
                g.a[r2[i]][r2[j]] = g2.a[i][j];
            }
        }
        g.a[mini][minj] = g.a[minj][mini] = min;
        return g;
    }

    public void run() throws IOException {
        Scanner in = new Scanner(new File("matrix.in"));
        PrintWriter out = new PrintWriter(new File("matrix.out"));

        int n = in.nextInt();
        int[][] a = new int[n][n];
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                a[i][j] = in.nextInt();
            }
        }

        Graph g = create(a);
        if (g == null) {
            out.println("NO");
        } else {
            out.println("YES");
            out.println(n - 1);
            for (int i = 0; i < n; i++) {
                for (int j = i + 1; j < n; j++) {
                    if (g.a[i][j] > 0) {
                        out.println((i + 1) + " " + (j + 1) + " " + g.a[i][j]);
                    }
                }
            }
        }

        in.close();
        out.close();
    }

    public static void main(String[] arg) throws IOException {
        new m().run();
    }
}
