/***************************************************************
**
**         ---- Jury's checker for the problem ----
**
**                --  "Reserve"  --
**
**  file: check.cpp
**
**  11 august   2007 - created
**
***************************************************************/

#include "testlib.h"
#include <iostream>

//--------------------------------------------------------------

#define N 64
#define oo 1000000000
 
using namespace std;

//--------------------------------------------------------------

int n;
int X[N][N];
int B[N];
int C[N][N];

void Check()  {
	int i, j, k;
	int JuryValue, GivenValue;
		
	JuryValue = ans.readInt();
	GivenValue = ouf.readInt();
        		
	n = inf.readInt();

	if(n<1||n>50) quit(_fail, "n is incorrect");
	
	for(i=1; i<=n; i++)
		for(j=i; j<=n; j++) {
			X[i][j] = ouf.readInt();
			if(X[i][j]<0||X[i][j]>1000000000) quit(_fail, "Number of Zealots is incorrect");		
		}
	
	for(i=1; i<=n; i++)
		for(j=i; j<=n; j++) {
			C[i][j] = inf.readInt();
			if(C[i][j]<0||C[i][j]>10000) quit(_fail, "C[i][j] is incorrect");
		}
			
	for(i=1; i<=n; i++) {
		B[i] = inf.readInt();
		if(B[i]<0||B[i]>2000) quit(_fail, "B[i] is incorrect");
	}
		
	for(k=1; k<=n; k++) {
		int q(0);
		for(i=1; i<=n; i++) {
			for(j=i; j<=n; j++)
				if(k>=i && k<=j)
					q += X[i][j];
		}	
		if(q < B[k]) {
			quit(_wa, "Given solution is not feasible");			
		}
	}
	
	int value(0);
	for(i=1; i<=n; i++)
		for(j=i; j<=n; j++)
			value += C[i][j]*X[i][j];

	if(value>1000000000)  quit(_fail, "value is too large incorrect");
			
	if(value != GivenValue)
		quit(_wa, "Given value is not equal to the real");
			
	if(JuryValue < GivenValue)
		quit(_wa, "Jury's value is more optimal :)");
	else if(JuryValue > GivenValue)
		quit(_wa, "Given value is more optimal than the jury's one!!!");

	quit(_ok, "Accepted???");
}

//--------------------------------------------------------------

int main(int argc, char *argv[])  {

//	inf.init(argv[1], _input);
//	ouf.init(argv[2], _output);
//	ans.init(argv[3], _answer);
	registerTestlibCmd (argc, argv);
	
//	inf.init("reserve.in", _input);
//	ouf.init("reserve.out", _output);
	
	Check();

	return 0;
}

//-- End of file -----------------------------------------------
