#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <cstdio>
#include <cmath>
#include <vector>
#include <algorithm>
#include <string>
#include <memory.h>
using namespace std;

const long double eps = 1e-12;

int n, m, k;
int c[210];
int ma[210][210];
int l[210];

void Load()
{
	scanf("%d%d%d", &n, &m, &k);
	int i;
	for (i = 1; i <= n; i++)
	{
		scanf("%d", &c[i]);
	}
	memset(ma, 0, sizeof(ma));
	for (i = 1; i <= n; i++)
	{
		scanf("%d", &l[i]);
	}
	for (i = 0; i < m; i++)
	{
		int p, q;
		scanf("%d%d", &p, &q);
		ma[p][q] = 1;
	}
}

const int MANY = 0x7FFFFFFF;

class Edge
{
public:
	int be, en, cpc, bcpc;
};

inline int Inv(int pos)
{
	return pos ^ 1;
}

vector<Edge> edg;
int first[210];
int next[51000];
int bver, ever;
int bigcnt;
int was[210];

void AddEdge(int v1, int v2, int c)
{
	Edge a;
	a.be = v1;
	a.en = v2;
	a.cpc = a.bcpc = c;
	edg.push_back(a);
	next[edg.size() - 1] = first[v1];
	first[v1] = edg.size() - 1;
}

int Dfs(int ver, int &min)
{
	if (ver == ever) return 1;
	was[ver] = 1;
	int i;
	for (i = first[ver]; i != -1; i = next[i])
	{
		if (was[edg[i].en] == 1) continue;
		if (edg[i].cpc < bigcnt) continue;
		int cmin = min;
		if (edg[i].cpc < cmin) cmin = edg[i].cpc;
		if (Dfs(edg[i].en, cmin))
		{
			min = cmin;
			edg[i].cpc -= cmin;
			edg[Inv(i)].cpc += cmin;
			return 1;
		}
	}
	return 0;
}

int MaxFlow()
{
	int res, min;
	min = MANY;
	res = 0;
	bigcnt = MANY;
	while (bigcnt > 0)
	{
		memset(was, 0, sizeof(was));
		while (Dfs(bver, min))
		{
			memset(was, 0, sizeof(was));
			res += min;
			min = MANY;
		}
		bigcnt /= 2;
	}
	return res;
}

void Solve()
{
	memset(first, 0xFF, sizeof(first));
	memset(next, 0xFF, sizeof(next));
	int i, j;
	for (i = 1; i <= n; i++)
	{
		for (j = 1; j <= n; j++)
		{
			if (ma[i][j] == 1)
			{
				AddEdge(i, j, MANY);
				AddEdge(j, i, 0);
			}
		}
	}
	for (i = 1; i <= n; i++)
	{
		if (c[i] > 0) 
		{
			AddEdge(n + 1, i, c[i]);
			AddEdge(i, n + 1, 0);
		}
		else
		{
			AddEdge(n + 2, i, 0);
			AddEdge(i, n + 2, -c[i]);
		}
	}
	bver = n + 1;
	ever = n + 2;
	int res = -MaxFlow();
	for (i = 1; i <= n; i++) if (c[i] > 0) res += c[i];
	bigcnt = 1;
	memset(was, 0, sizeof(was));
	int cmin = MANY;
	Dfs(bver, cmin);
	printf("%d\n", res);
	int num = 0;
	for (i = 1; i <= n; i++) if (was[i] == 1) num++;
	printf("%d\n", num);
	for (i = 1; i <= n; i++) if (was[i] == 1) printf("%d ", i);
}

int main()
{
	freopen("defense.in", "rt", stdin);
	freopen("defense.out", "wt", stdout);
	Load();
	Solve();
	return 0;
}