import java.io.*;
import java.util.*;
import static java.lang.Math.*;

public class d implements Runnable {

    class Edge {
        int d;
        int l;
        int ind;
        Edge r;

        public Edge(int t, int l, int ind) {
            this.d = t;
            this.l = l;
            this.ind = ind;
        }
    }

    class Heap {
        int s;
        Pair[] h;
        int[] pos;

        public Heap(int n) {
            h = new Pair[n];
            pos = new int[n];
            s = 0;
        }

        public void clean() {
            s = 0;
        }

        public void insert(int key, int value) {
            h[s] = new Pair(key, value);
            pos[key] = s;
            s++;
            siftUp(s - 1);
        }

        public void decreaseKey(int key, int value) {
            int x = pos[key];
            h[x].value = value;
            siftUp(x);
        }

        public int extractMin() {
            int r = h[0].key;
            h[0] = h[s - 1];
            pos[h[0].key] = 0;
            s--;
            siftDown(0);
            return r;
        }

        public void siftUp(int x) {
            Pair t = h[x];
            while (x > 0 && h[(x - 1) / 2].value > t.value) {
                h[x] = h[(x - 1) / 2];
                pos[h[x].key] = x;
                x = (x - 1) / 2;
            }
            h[x] = t;
            pos[h[x].key] = x;
        }

        public void siftDown(int x) {
            while (2 * x + 1 < s) {
                int y = x;
                if (h[2 * x + 1].value < h[y].value) {
                    y = 2 * x + 1;
                }
                if (2 * x + 2 < s && h[2 * x + 2].value < h[y].value) {
                    y = 2 * x + 2;
                }
                if (y == x) {
                    break;
                }
                Pair t = h[x];
                h[x] = h[y];
                h[y] = t;
                pos[h[x].key] = x;
                pos[h[y].key] = y;
                x = y;
            }
        }

        int size() {
            return s;
        }
    }

    public class Pair {
        int key;
        int value;

        public Pair(int key, int value) {
            this.key = key;
            this.value = value;
        }
    }

    ArrayList<Edge>[] edges;
    ArrayList<Edge>[] edges0;

    boolean[] visited;

    void dfsr(int x) {
        visited[x] = true;

        for (Edge e : edges0[x]) {
            if (!visited[e.d]) {
                dfsr(e.d);
            }
        }
    }

    int[] enter;
    int[] phi;
    int time;

    ArrayList<Integer> bridges;

    void dfs(int x, Edge pe) {
        visited[x] = true;
        enter[x] = time++;
        phi[x] = enter[x];

        for (Edge e : edges0[x]) {
            if (!visited[e.d]) {
                dfs(e.d, e);
                if (phi[e.d] < phi[x]) {
                    phi[x] = phi[e.d];
                }
            } else {
                if (pe == null || e != pe.r) {
                    phi[x] = min(phi[x], enter[e.d]);
                }
            }
        }

        if (phi[x] == enter[x] && x != 0) {
            bridges.add(pe.ind);
        }
    }

    public void solve() throws IOException {
        BufferedReader in = new BufferedReader(new FileReader("important.in"));
        PrintWriter out = new PrintWriter(new File("important.out"));

        StringTokenizer st = new StringTokenizer(in.readLine());
        int n = Integer.parseInt(st.nextToken());
        int m = Integer.parseInt(st.nextToken());

        edges = new ArrayList[n];
        for (int i = 0; i < n; i++) {
            edges[i] = new ArrayList<Edge>();
        }

        for (int i = 0; i < m; i++) {
            st = new StringTokenizer(in.readLine());
            int s = Integer.parseInt(st.nextToken()) - 1;
            int t = Integer.parseInt(st.nextToken()) - 1;
            int l = Integer.parseInt(st.nextToken());
            assert l > 0 && l <= 100000;
            Edge e1 = new Edge(t, l, i + 1);
            Edge e2 = new Edge(s, l, i + 1);
            edges[s].add(e1);
            edges[t].add(e2);
            e1.r = e2;
            e2.r = e1;
        }

        int[] d = new int[n];
        boolean[] u = new boolean[n];
        Heap h = new Heap(n);
        Arrays.fill(u, false);
        Arrays.fill(d, 0);

        // Run Dijkstra
        d[0] = 0;
        u[0] = true;
        h.clean();
        h.insert(0, 0);

        while (h.size() > 0) {
            int k = h.extractMin();

            for (Edge e : edges[k]) {
                int newd = d[k] + e.l;
                if (!u[e.d] || d[e.d] > newd) {
                    if (!u[e.d]) {
                        h.insert(e.d, newd);
                    } else {
                        h.decreaseKey(e.d, newd);
                    }
                    u[e.d] = true;
                    d[e.d] = newd;
                }
            }
        }

        edges0 = new ArrayList[n];
        for (int i = 0; i < n; i++) {
            edges0[i] = new ArrayList<Edge>();
        }
        for (int i = 0; i < n; i++) {
            for (Edge e : edges[i]) {
                if (d[e.d] - d[i] == e.l) {
                    edges0[e.d].add(new Edge(i, e.l, e.ind));
                }
            }
        }

        assert u[n - 1];

        visited = new boolean[n];
        dfsr(n - 1);

        for (int i = 0; i < n; i++) {
            edges0[i].clear();
        }
        for (int i = 0; i < n; i++) {
            if (!visited[i]) {
                continue;
            }

            for (Edge e : edges[i]) {
                if (d[e.d] - d[i] == e.l && visited[e.d]) {
                    edges0[i].add(e);
                    edges0[e.d].add(e.r);
                }
            }
        }

        enter = new int[n];
        phi = new int[n];
        bridges = new ArrayList<Integer>();
        Arrays.fill(visited, false);
        dfs(0, null);

        out.println(bridges.size());
        for (int x : bridges) {
            out.print(x + " ");
        }

        in.close();
        out.close();
    }

    public void run() {
        try {
            solve();
        } catch (IOException e) {
            System.exit(64);
        }
    }

    public static void main(String[] arg) throws IOException {
        new Thread(new d()).start();
    }
}
